/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.cable;

import com.google.common.collect.Iterables;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.cable.CableBlock;
import owmii.powah.block.cable.CableNet;
import owmii.powah.config.v2.types.CableConfig;
import owmii.powah.lib.block.AbstractEnergyStorage;
import owmii.powah.lib.block.IInventoryHolder;

public abstract class CableTile
extends AbstractEnergyStorage<CableConfig, CableBlock>
implements IInventoryHolder {
    private static final String NBT_ENERGY_SIDES = "cs";
    public final EnumSet<Direction> energySides = EnumSet.noneOf(Direction.class);
    @Nullable
    CableNet net = null;
    protected int startIndex = 0;

    public CableTile(BlockPos pos, BlockState state, Tier variant) {
        super(Tiles.CABLE.get(), pos, state, variant);
    }

    public void m_6339_() {
        super.m_6339_();
        CableNet.addCable(this);
    }

    public void m_7651_() {
        super.m_7651_();
        CableNet.removeCable(this);
    }

    public boolean isActive() {
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.m_7726_().m_143239_(ChunkPos.m_151388_((BlockPos)this.m_58899_()));
        }
        return false;
    }

    protected Iterable<CableTile> getCables() {
        if (this.net == null) {
            CableNet.calculateNetwork(this);
        }
        this.startIndex %= this.net.cableList.size();
        return Iterables.concat(this.net.cableList.subList(this.startIndex, this.net.cableList.size()), this.net.cableList.subList(0, this.startIndex));
    }

    @Override
    public void readSync(CompoundTag compound) {
        super.readSync(compound);
        this.readEnergySides(compound);
    }

    @Override
    public CompoundTag writeSync(CompoundTag compound) {
        this.writeEnergySides(compound);
        return super.writeSync(compound);
    }

    private void readEnergySides(CompoundTag compound) {
        this.energySides.clear();
        byte sideBits = compound.m_128445_(NBT_ENERGY_SIDES);
        for (Direction side : Direction.values()) {
            if ((sideBits & CableTile.getSideMask(side)) == 0) continue;
            this.energySides.add(side);
        }
    }

    private void writeEnergySides(CompoundTag compound) {
        byte sideBits = 0;
        for (Direction side : this.energySides) {
            sideBits = (byte)(sideBits | CableTile.getSideMask(side));
        }
        compound.m_128344_(NBT_ENERGY_SIDES, sideBits);
    }

    private static byte getSideMask(Direction side) {
        return (byte)(1 << side.ordinal());
    }

    @Override
    protected long getEnergyCapacity() {
        return 0L;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 0;
    }

    @Override
    public boolean canInsert(int slot, ItemStack stack) {
        return false;
    }

    @Override
    public boolean canExtract(int slot, ItemStack stack) {
        return false;
    }

    @Override
    public boolean keepStorable() {
        return false;
    }
}

